

% cd('D:\Google Drive\Projects\HI-SCALE SGP\Scripts_moved');

load('E:\Google Drive\Projects\HI-SCALE SGP\Scripts_moved\ImportedPSAPdata_IOP1_frompsap2folder.mat','PSAPtime','PSAPabsred','PSAPabsblue','RBangstrom','avgPSAPtime','avgangrb','avgred','avgblue','SigmaBPSAP','SigmaRPSAP','SigmaGPSAP');

[~,may8startidx_raw] = min(abs(datenum(PSAPtime) - datenum([2016,05,8,00,00,00])));
[~,may8endidx_raw] = min(abs(datenum(PSAPtime) - datenum([2016,05,9,00,00,00])));

[~,may8startidx_avg] = min(abs(datenum(avgPSAPtime) - datenum([2016,05,8,00,00,00])));
[~,may8endidx_avg] = min(abs(datenum(avgPSAPtime) - datenum([2016,05,9,00,00,00])));
% newavgpsaptime = avgPSAPtime;
% newavgpsaptime(may8startidx : may8endidx) = datetime(datenum(NaN));

%% Red
newrawred = double(SigmaRPSAP);
newrawred(may8startidx_raw : may8endidx_raw) = NaN;
rawredfilt = medfilt1(newrawred);

%% Blue
newrawblue = double(SigmaBPSAP);
newrawblue(may8startidx_raw : may8endidx_raw) = NaN;
rawbluefilt = medfilt1(newrawblue);

%% Green
newrawgreen = double(SigmaGPSAP);
newrawgreen(may8startidx_raw : may8endidx_raw) = NaN;
rawgreenfilt = medfilt1(newrawgreen);

%% R/B AAE
newrawRBang = double(RBangstrom);
newrawRBang(may8startidx_raw : may8endidx_raw) = NaN;



%% Rolling Average of Red and Blue abs coeff and RBangstrom
windowsize = 30;
[avgPSAPtime,avgred] = RollingAverage(PSAPtime,newrawred,windowsize);
[~,avgblue] = RollingAverage(PSAPtime,newrawblue,windowsize);
[~,avggreen] = RollingAverage(PSAPtime,newrawgreen,windowsize);
[~,avgangrb] = RollingAverage(PSAPtime,newrawRBang,windowsize);

%% Converting Red to double and filtering
newavgred = double(avgred);
newavgred(may8startidx_avg : may8endidx_avg) = NaN;
redfilt = medfilt1(newavgred);

%% Converting Blue to double and filtering
newavgblue = double(avgblue);
newavgblue(may8startidx_avg : may8endidx_avg) = NaN;
bluefilt = medfilt1(newavgblue);

%% Converting Green to double and filtering
newavggreen = double(avggreen);
newavggreen(may8startidx_avg : may8endidx_avg) = NaN;
greenfilt = medfilt1(newavggreen);

%% Converting RBangstrom to double and filtering
newavgangrb = double(avgangrb);
newavgangrb(may8startidx_avg : may8endidx_avg) = NaN;
angrbfilt = medfilt1(newavgangrb);

%% Calculating RB angstrom Error
err_ang = log(660./470) .* 0.1 .* sqrt((1./bluefilt).^2 + (1./redfilt).^2);
